<?php
/**
 * Plugin Name: SociTrafficBot AI
 * Description: Add 5-in-1 social content generator on your site's frontend (so your site visitors can use the tool while browsing your website)
 * Plugin URI: https://wpthemeplugin.com/
 * Author: Leo BCBiz (WpThemePlugin.com)
 * Version: 1.0.1
 * Author URI: https://wpthemeplugin.com/
 * Requires at least: 5.6
 * Requires PHP: 7.0
*/
function enqueue_stbwtp_script() {
    wp_enqueue_script( 'stbwtp-fe-ajaxscript', plugin_dir_url(__FILE__).'stbwtpajax-script.js', array('jquery'), '1.0.1', true );
    $stbwtpvar = array(
        'stbwtpajaxurl' => admin_url( 'admin-ajax.php' )
    );
    wp_localize_script('stbwtp-fe-ajaxscript', 'stbwtpleo', $stbwtpvar);
}
add_action( 'wp_enqueue_scripts', 'enqueue_stbwtp_script' );

if ( ! function_exists( 'wtp_custom_curl_timeout' ) ) {
    add_action('http_api_curl', 'wtp_custom_curl_timeout', 9999, 1);
    function wtp_custom_curl_timeout( $handle ){
	    curl_setopt( $handle, CURLOPT_CONNECTTIMEOUT, 60 );
	    curl_setopt( $handle, CURLOPT_TIMEOUT, 60 );
    }
}
require 'kernl-update-checker/kernl-update-checker.php';
if ( ! function_exists( 'wtp_custom_http_request_timeout' ) ) {
    add_filter( 'http_request_timeout', 'wtp_custom_http_request_timeout', 9999 );
    function wtp_custom_http_request_timeout( $timeout_value ) {
	    return 60;
    }
}

if ( ! function_exists( 'wtp_custom_http_request_args' ) ) {
    add_filter('http_request_args', 'wtp_custom_http_request_args', 9999, 1);
    function wtp_custom_http_request_args( $r ){
	    $r['timeout'] = 60;
	    return $r;
    }
}
class SociTrafficBotWTP {
	private $socitrafficbot_wtp_options;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'socitrafficbot_wtp_add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'socitrafficbot_wtp_page_init' ) );
	}

	public function socitrafficbot_wtp_add_plugin_page() {
		add_management_page(
			'SociTrafficBot WTP', // page_title
			'SociTrafficBot WTP', // menu_title
			'manage_options', // capability
			'socitrafficbot-wtp', // menu_slug
			array( $this, 'socitrafficbot_wtp_create_admin_page' ) // function
		);
	}

	public function socitrafficbot_wtp_create_admin_page() {
		$this->socitrafficbot_wtp_options = get_option( 'socitrafficbot_wtp_option_name' ); ?>

        <style>
		    .wtp-logo-top {
		        padding-top:7px;
		    }
		    
		    .wtp-logo-top a {
		        color: #fff;
		        text-decoration: none;
		        font-size: 8px;
		        background: linear-gradient(to right, #e47a66 10%, #e99484 61%, #e47a66 100%);
		        padding: 4px 10px;
		        border-radius: 2px;
		    }
		    
		    .wtp-logo-top a:hover {
		        opacity:0.85;
		    }
		    
		    .stbwtp-userpage {
                background:#fff;
                max-width:710px;
                margin-top:30px;
                padding:20px 20px 15px;
                border:1px solid #ccc;
                border-radius:4px;
                font-size:15px;
            }
            .stbwtp-userpage p {
                font-size:15px;
            }
		</style>
		
		
		<div class="wrap">
		    
			<h2>SociTrafficBot WTP</h2>
			<div class="wtp-logo-top">
                <a href="https://wpthemeplugin.com" target="_blank">BY WPTHEMEPLUGIN.COM</a>
            </div>
			
			<div class="stbwtp-userpage">
			    
			    <h4 style="font-size:17px;margin:0 0 25px;padding:0;">
			        How to Use The Plugin
			    </h4>
			    
			    <p>1. Edit an existing content that you want, or create a new WP Posts or Pages.</p>
			    <p>2. Inside the WP Editor, insert this shortcode: [socitrafficbot-wtp]</p>
			    
			    <img src="<?php echo plugin_dir_url( __FILE__ ) . 'socitrafficbot-sc-1.png'; ?>" style="max-width:400px;border:1px solid #ccc;border-radius:6px;">
			    
			    <p>3. Update or Publish your WP Content.</p>
			    
			    <p>And that's it!</p>
			    
			    <p>After the shortcode is inserted, then visitors who visit that content can now use SociTrafficBot :o)</p>
			    
			    <p>By using this plugin, you can <strong>target traffic-getting keywords</strong> such as: Free Social Post Generator, AI Social Content Generator and so on..</p>
			    
			    <div style="clear:both;height:30px;"></div>
			    
			    <h4 style="font-size:17px;margin-bottom:25px;">
			        Add More AI Tools to Your Website:
			    </h4>
        
                <div style="display:inline-block;margin-right:35px;">
                    <a href="https://wpthemeplugin.com/azon-ailabs-wtp/" target="_blank"><img src="https://d2c136330chs5t.cloudfront.net/AITools/9-AIMailsLab/azonailabs-ecover-2.png" class="moveup" style="padding:8px;max-width:300px;border:1px solid #ccc;border-radius:8px;"></a>
                </div>
        
                <div style="display:inline-block;">
                    <a href="https://wpthemeplugin.com/aipb-special/" target="_blank"><img src="https://d2c136330chs5t.cloudfront.net/WTPV3/AIPB/aiprofitbooster-cover-6.png" class="moveup" style="padding:8px;max-width:300px;border:1px solid #ccc;border-radius:8px;"></a>
                </div>
                
                <div style="clear:both;height:30px;"></div>
			</div>
			
		</div><!-- wrap -->
		
	<?php }

	public function socitrafficbot_wtp_page_init() {
		register_setting(
			'socitrafficbot_wtp_option_group', // option_group
			'socitrafficbot_wtp_option_name', // option_name
			array( $this, 'socitrafficbot_wtp_sanitize' ) // sanitize_callback
		);

		add_settings_section(
			'socitrafficbot_wtp_setting_section', // id
			'Settings', // title
			array( $this, 'socitrafficbot_wtp_section_info' ), // callback
			'socitrafficbot-wtp-admin' // page
		);

		add_settings_field(
			'license_key_0', // id
			'License Key', // title
			array( $this, 'license_key_0_callback' ), // callback
			'socitrafficbot-wtp-admin', // page
			'socitrafficbot_wtp_setting_section' // section
		);
	}

	public function socitrafficbot_wtp_sanitize($input) {
		$sanitary_values = array();
		if ( isset( $input['license_key_0'] ) ) {
			$sanitary_values['license_key_0'] = sanitize_text_field( $input['license_key_0'] );
		}

		return $sanitary_values;
	}

	public function socitrafficbot_wtp_section_info() {
		
	}

	public function license_key_0_callback() {
		printf(
			'<input class="regular-text" type="text" name="socitrafficbot_wtp_option_name[license_key_0]" id="license_key_0" value="%s">',
			isset( $this->socitrafficbot_wtp_options['license_key_0'] ) ? esc_attr( $this->socitrafficbot_wtp_options['license_key_0']) : ''
		);
	}

}
if ( is_admin() )
	$socitrafficbot_wtp = new SociTrafficBotWTP();

/* 
 * Retrieve this value with:
 * $socitrafficbot_wtp_options = get_option( 'socitrafficbot_wtp_option_name' ); // Array of All Options
 * $license_key_0 = $socitrafficbot_wtp_options['license_key_0']; // License Key
 */

