<?php
/**
 * Plugin Name: KeywordZon WTP
 * Description: Monetize your site content with Amazon affiliate products based on the keyword that you set (use it instantly: no Amazon API Key needed)
 * Plugin URI: https://wpthemeplugin.com/
 * Author: Leo BCBiz (WpThemePlugin.com)
 * Version: 1.0.1
 * Author URI: https://wpthemeplugin.com/
 * Requires at least: 5.6
 * Requires PHP: 7.0
*/

if ( ! function_exists( 'wtp_custom_curl_timeout' ) ) {
    add_action('http_api_curl', 'wtp_custom_curl_timeout', 9999, 1);
    function wtp_custom_curl_timeout( $handle ){
	    curl_setopt( $handle, CURLOPT_CONNECTTIMEOUT, 60 );
	    curl_setopt( $handle, CURLOPT_TIMEOUT, 60 );
    }
}

if ( ! function_exists( 'wtp_custom_http_request_timeout' ) ) {
    add_filter( 'http_request_timeout', 'wtp_custom_http_request_timeout', 9999 );
    function wtp_custom_http_request_timeout( $timeout_value ) {
	    return 60;
    }
}

if ( ! function_exists( 'wtp_custom_http_request_args' ) ) {
    add_filter('http_request_args', 'wtp_custom_http_request_args', 9999, 1);
    function wtp_custom_http_request_args( $r ){
	    $r['timeout'] = 60;
	    return $r;
    }
}
require 'kernl-update-checker/kernl-update-checker.php';
class KeywordZonWTP {
	private $keywordzon_wtp_options;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'keywordzon_wtp_add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'keywordzon_wtp_page_init' ) );
	}

	public function keywordzon_wtp_add_plugin_page() {
		add_options_page(
			'KeywordZon WTP', // page_title
			'KeywordZon WTP', // menu_title
			'manage_options', // capability
			'keywordzon-wtp', // menu_slug
			array( $this, 'keywordzon_wtp_create_admin_page' ) // function
		);
	}

	public function keywordzon_wtp_create_admin_page() {
		$this->keywordzon_wtp_options = get_option( 'keywordzon_wtp_option_name' ); ?>
		
		<div style="margin:20px 0 20px 15px;" class="wrap">
            <a href="https://wpthemeplugin.com/" target="_blank"><img src="https://d2c136330chs5t.cloudfront.net/WTP2023/PluginBonus/keywordzon-wtp-logo-3.png" width="240" style="float:left;margin-right:15px;" /></a>
        
            <div style="padding-top:8px;">
                <a href="https://wpthemeplugin.com" style="color: #fff; text-decoration: none; font-size: 9px; font-weight:bold;background: linear-gradient(#ff9a00, #ff7400, #ff0000); padding: 4px 20px; border-radius: 12px;" target="_blank">BY WPTHEMEPLUGIN.COM</a>
            </div>
            <div style="clear:both;"></div>
        </div><!--.aiazstore-logo-->


        <?php
            include 'keywordzon-settings-page.php';
        ?>


		
	<?php }

	public function keywordzon_wtp_page_init() {
		register_setting(
			'keywordzon_wtp_option_group', // option_group
			'keywordzon_wtp_option_name', // option_name
			array( $this, 'keywordzon_wtp_sanitize' ) // sanitize_callback
		);

		add_settings_section(
			'keywordzon_wtp_setting_section', // id
			'Settings', // title
			array( $this, 'keywordzon_wtp_section_info' ), // callback
			'keywordzon-wtp-admin' // page
		);

		add_settings_field(
			'license_key_0', // id
			'License Key', // title
			array( $this, 'license_key_0_callback' ), // callback
			'keywordzon-wtp-admin', // page
			'keywordzon_wtp_setting_section' // section
		);
	}

	public function keywordzon_wtp_sanitize($input) {
		$sanitary_values = array();
		if ( isset( $input['license_key_0'] ) ) {
			$sanitary_values['license_key_0'] = sanitize_text_field( $input['license_key_0'] );
		}

		return $sanitary_values;
	}

	public function keywordzon_wtp_section_info() {
		
	}

	public function license_key_0_callback() {
		printf(
			'<input class="regular-text" type="text" name="keywordzon_wtp_option_name[license_key_0]" id="license_key_0" value="%s">',
			isset( $this->keywordzon_wtp_options['license_key_0'] ) ? esc_attr( $this->keywordzon_wtp_options['license_key_0']) : ''
		);
	}

}
if ( is_admin() )
	$keywordzon_wtp = new KeywordZonWTP();

/* 
 * Retrieve this value with:
 * $keywordzon_wtp_options = get_option( 'keywordzon_wtp_option_name' ); // Array of All Options
 * $license_key_0 = $keywordzon_wtp_options['license_key_0']; // License Key
 */
